### **VPN Types**

VPNs can be classified based on the following criteria:

#### **1. Based on Deployment Mode**

- **Site-to-Site VPN**:
    
    - Connects entire networks, such as branch offices to headquarters.
    - Replaces traditional leased lines or Frame Relay connections using the internet.
    - Hosts do not need client software; traffic flows through a VPN gateway.
    - Key devices: Cisco IOS XE routers, Cisco Secure Firewall ASA, Cisco Secure Firewall Threat Defense.
- **Remote-Access VPN**:
    
    - Connects individual users securely to the corporate network over the internet.
    - Commonly used by telecommuters, mobile users, and consumer-to-business extranet traffic.
    - Requires either:
        - **VPN Client Software**: Cisco Secure Client (formerly Cisco AnyConnect).
        - **Clientless SSL VPN**: Browser-based VPN using HTTPS (deprecated in newer Cisco ASA versions).
    - Key devices: Cisco Secure Firewall ASA, Cisco Secure Firewall Threat Defense.

#### **2. Based on OSI Layer**

- **Layer 2 VPN**:
    - Uses legacy protocols like Frame Relay and Layer 2 MPLS VPN.
- **Layer 3 VPN**:
    - Examples: IPsec VPN and MPLS Layer 3 VPN.
- **Layer 7 VPN**:
    - Example: SSL VPN.

#### **3. Based on Underlying Technology**

- **IPsec VPN**: Provides encryption and authentication at the network layer.
- **SSL VPN**: Operates at the application layer using web-based encryption.
- **MPLS VPN**: Uses MPLS technology for secure data transfer.
- **Hybrid VPN**: Combines multiple technologies (e.g., IPsec and MPLS).

---

### **VPN Components**

Key components of a VPN implementation include the following:

#### **1. Authentication**

- **Device Authentication**:
    - Restricts VPN access based on the device's credentials.
    - Methods: Pre-shared keys or digital certificates.
- **User Authentication**:
    - Verifies the user trying to establish the connection.
    - Methods:
        - Username and password (static or one-time passwords via tokens).
        - Dual-factor authentication (e.g., password + token or Cisco Duo).

#### **2. Encapsulation Method**

- Defines how user data is encapsulated for secure transport.
- Determines which applications or protocols can be sent over the VPN.

#### **3. Data Encryption**

- Protects data against eavesdropping.
- Uses encryption algorithms such as:
    - DES, 3DES, AES, Blowfish, RSA, SEAL, RC4, etc.
- Only devices with matching keys can decrypt the data.

#### **4. Packet Integrity**

- Ensures data has not been altered during transmission.
- Methods:
    - Digital signature creation using hashing algorithms (e.g., SHA-1, SHA-2).
    - Hashing verifies the packet's authenticity and integrity.

#### **5. Key Management**

- Handles the derivation and regeneration of encryption keys.
- Keys can be statically configured or dynamically generated.

#### **6. Non-Repudiation**

- Ensures that the communication between peers is verifiable.
- Two components:
    - **Authentication**: Verifies device/user identity.
    - **Accounting**: Logs session details (duration, data transmitted, etc.).

#### **7. Application and Protocol Support**

- Determines which types of traffic need to be protected (e.g., IP traffic).
- Ensures VPN implementation supports required applications and protocols.

#### **8. Address Management**

- Primarily for remote-access VPNs.
- Tracks internal address assignments to remote clients to avoid conflicts.
- Poor address management can affect VPN implementation efficiency.

---

### **Notes**

- **Cisco Secure Client**:
    - Latest version of Cisco AnyConnect.
    - Offers advanced remote-access services and security modules.
- **Clientless SSL VPN**:
    - Deprecated in Cisco ASA version 9.17 (no longer supported on Cisco Secure Firewall Threat Defense).